<?php
/**
 * Ugm Show10 module
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright  The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license    http://www.fsf.org/copyleft/gpl.html GNU public license
 * @package    Ugm Show10
 * @since      2.5
 * @author     育將電腦工作室
 * @version    $Id $
 *
 *  The block_type is in a mess, let's say:
 *  S - generated by system module
 *  M - generated by a non-system module
 *  C - Custom block
 *  D - cloned system/module block
 *  E - cloned custom block, DON'T use it
 **/

#引入類別物件---------------------------------
include_once XOOPS_ROOT_PATH."/modules/ugm_tools/ugmKind.php";


function xoops_module_install_ugm_xbootstrap(&$module)
{
    mk_dir(XOOPS_ROOT_PATH . "/uploads/ugm_xbootstrap");
    #----
    go_install();
    #產生預設樣板
    write_ugm_xbootstrap_html();
    XoopsCache::clear();
    return true;
}



//將預設系統項目寫入資料庫
function go_install(){
  global $xoopsDB;

  $i=0;
  #---- system ----
  #佈景logo圖
  $configs['nav'][$i]['name'] = 'system_nav_logo';
  $configs['nav'][$i]['title'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_1';
  $configs['nav'][$i]['description'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_1_DESC';
  $configs['nav'][$i]['formtype'] = 'file';
  $configs['nav'][$i]['valuetype'] = 'single_img';
  $configs['nav'][$i]['default'] = 200;//最大寬度360px

  $i++;
  #「首頁訊息_標題」
  $configs['message_home'][$i]['name'] = 'system_message_home_title';
  $configs['message_home'][$i]['title'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_2';
  $configs['message_home'][$i]['description'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_2_DESC';
  $configs['message_home'][$i]['formtype'] = 'textbox';
  $configs['message_home'][$i]['valuetype'] = 'text';
  $configs['message_home'][$i]['default'] = 'Message';

  $i++;
  #「首頁訊息內容」
  $configs['message_home'][$i]['name'] = 'system_message_home_content';
  $configs['message_home'][$i]['title'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_3';
  $configs['message_home'][$i]['description'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_3_DESC';
  $configs['message_home'][$i]['formtype'] = 'fck';
  $configs['message_home'][$i]['valuetype'] = 'text';
  $configs['message_home'][$i]['default'] = "Content";

  $i++;
  #「首頁訊息 連結網址」
  $configs['message_home'][$i]['name'] = 'system_message_home_url';
  $configs['message_home'][$i]['title'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_4';
  $configs['message_home'][$i]['description'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_4_DESC';
  $configs['message_home'][$i]['formtype'] = 'textbox';
  $configs['message_home'][$i]['valuetype'] = 'text';
  $configs['message_home'][$i]['default'] = "#";

  $i++;
  #「首頁訊息 啟用狀態」
  $configs['message_home'][$i]['name'] = 'system_message_home_enable';
  $configs['message_home'][$i]['title'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_5';
  $configs['message_home'][$i]['description'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_5_DESC';
  $configs['message_home'][$i]['formtype'] = 'yesno';
  $configs['message_home'][$i]['valuetype'] = 'int';
  $configs['message_home'][$i]['default'] = "1";

  $i++;
  #「首頁訊息 外連狀態」
  $configs['message_home'][$i]['name'] = 'system_message_home_target';
  $configs['message_home'][$i]['title'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_6';
  $configs['message_home'][$i]['description'] = '_MD_UGMXBOOTSTRAP_SYSTEM_NAME_6_DESC';
  $configs['message_home'][$i]['formtype'] = 'yesno';
  $configs['message_home'][$i]['valuetype'] = 'int';
  $configs['message_home'][$i]['default'] = "0";

  #寫入
  //---- 過濾資料 -----------------------------------------*/
  $myts =& MyTextSanitizer::getInstance();

  //sn  ofsn  title sort  enable  kind  url target
  foreach ($configs  as $kind=>$config_one){
    foreach ($config_one  as $sort=>$config){
      if(!check_system_nameKind($config['name'],$kind)){

        $config['default'] =$myts->addSlashes($config['default']);

        $sql="insert into ".$xoopsDB->prefix("ugm_xbootstrap_system")."
              (`name`,`title`,`value`,`description`,`formtype`,`valuetype`,`sort`,`enable`,`kind`) values
              ('{$config['name']}','{$config['title']}','{$config['default']}','{$config['description']}','{$config['formtype']}','{$config['valuetype']}','{$sort}','1','{$kind}')";//die($sql);
        $xoopsDB->queryF($sql)or redirect_header($_SERVER['PHP_SELF'],3, mysql_error());

      }
    }
  }
  #------------------------------
  write_ugm_xbootstrap_html();
  return true;
}

#---- 檢查ugm_xbootstrap_system是否有變數
function check_system_nameKind($name,$kind)
{
  global $xoopsDB;
  $sql="select sn
        from ".$xoopsDB->prefix("ugm_xbootstrap_system")."
        where name='{$name}' and kind='{$kind}'";//die($sql);
  $result=$xoopsDB->query($sql);
  list($sn)=$xoopsDB->fetchRow($result);
  if(empty($sn)) return false;
  return true;
}

//建立目錄

if(!function_exists("mk_dir")){
function mk_dir($dir = "")
{
    //若無目錄名稱秀出警告訊息
    if (empty($dir)) {
        return;
    }

    //若目錄不存在的話建立目錄
    if (!is_dir($dir)) {
        umask(000);
        //若建立失敗秀出警告訊息
        mkdir($dir, 0777);
    }
}
}

###############################################################################
#  產生預設樣板
###############################################################################
function write_ugm_xbootstrap_html()
{
  #----預設下拉選單
  mk_dir(XOOPS_ROOT_PATH . "/uploads/ugm_xbootstrap/nav");
  $source = XOOPS_ROOT_PATH."/themes/xbootstrap/tpl/nav-menu.html";
  $destination = XOOPS_ROOT_PATH."/uploads/ugm_xbootstrap/nav/nav_home.html";
  copy($source,$destination);
  #----預設logo
  mk_dir(XOOPS_ROOT_PATH . "/uploads/ugm_xbootstrap/system");
  mk_dir(XOOPS_ROOT_PATH . "/uploads/ugm_xbootstrap/system/nav");
  $source = XOOPS_ROOT_PATH."/themes/xbootstrap/tpl/logo.html";
  $destination = XOOPS_ROOT_PATH."/uploads/ugm_xbootstrap/system/nav/logo.html";
  copy($source,$destination);
  #----預設輪播圖
  mk_dir(XOOPS_ROOT_PATH . "/uploads/ugm_xbootstrap/slider");
  $source = XOOPS_ROOT_PATH."/themes/xbootstrap/tpl/slider.html";
  $destination = XOOPS_ROOT_PATH."/uploads/ugm_xbootstrap/slider/slider_home.html";
  copy($source,$destination);
  #----預設首頁訊息
  mk_dir(XOOPS_ROOT_PATH . "/uploads/ugm_xbootstrap/system/message_home");
  $source = XOOPS_ROOT_PATH."/themes/xbootstrap/tpl/message_home.html";
  $destination = XOOPS_ROOT_PATH."/uploads/ugm_xbootstrap/system/message_home/message_home.html";
  copy($source,$destination);
}


